############### ###############
## Expectations Survey
## F_Expectations_1
## Project: CBO
## PI: Malte Lierl
## Written by: Malte Lierl
## Purpose: Visualize data from the expectations survey
## Date of creation: 2022-11-07
## This version: 2022-11-07
############### ###############

#Proportion of respondents anticipating rejection of negative effects on CBO functioning (H2)
length(expectations$H2[expectations$H2=="Reject"])/length(expectations$H2)

#Expectations were measured on a scale from -200 to 200, corresponding to -2.0 SD to +2.0 SD

mean.expectations.1 <- rbind(c("H1: Scope of CBO involvement", 6, mean_ci(expectations$H1_scope/100)),
                           c("H1: Intensity of CBO involvement", 5, mean_ci(expectations$H1_intensity/100)),
                           c("H1: Leaders' familiarity with CBO", 4, mean_ci(expectations$H1_familiarity/100)),
                           c("H4: Awareness of performance indicators", 3, mean_ci(expectations$H4_awareness/100)),
                           c("H4: Accuracy of leaders' beliefs about performance", 2, mean_ci(expectations$H4_accuracy/100)),
                           c("H5: Impact on municipal performance scores", 1, mean_ci(expectations$H5/100)))

colnames(mean.expectations.1) <- c("Hypothesis", "Position", "Mean", "Lower95", "Upper95")
mean.expectations.1 <- data.frame(mean.expectations.1)
mean.expectations.1$Position <- as.numeric(mean.expectations.1$Position)
mean.expectations.1$Mean <- as.numeric(mean.expectations.1$Mean)
mean.expectations.1$Lower95 <- as.numeric(mean.expectations.1$Lower95)
mean.expectations.1$Upper95 <- as.numeric(mean.expectations.1$Upper95)
mean.expectations.1

plot.expectations.1 <- ggplot(data=expectations) +
  geom_vline(aes(xintercept=0), lty=2) + 
  geom_hline(aes(yintercept=Position), lty=3, alpha=0.3, data=mean.expectations.1) + 
  geom_point(aes(x=H1_scope/100, y=6), alpha=0.3, size=3, color="cadetblue") + 
  geom_point(aes(x=H1_intensity/100, y=5), alpha=0.3, size=3, color="cadetblue") + 
  geom_point(aes(x=H1_familiarity/100, y=4), alpha=0.3, size=3, color="cadetblue") + 
  geom_point(aes(x=H4_awareness/100, y=3), alpha=0.3, size=3, color="cadetblue") + 
  geom_point(aes(x=H4_accuracy/100, y=2), alpha=0.3, size=3, color="cadetblue") + 
  geom_point(aes(x=H5/100, y=1), alpha=0.3, size=3, color="cadetblue") + 
  geom_errorbarh(aes(xmin=Lower95, xmax=Upper95, y=Position, height=0.2), lwd=1, color="firebrick4", data=mean.expectations.1) + 
  geom_point(aes(x=Mean, y=Position), shape=5, size=3, stroke=2, color="firebrick", data=mean.expectations.1) + 
  coord_cartesian(ylim=c(1,6), xlim=c(-2, 2)) + 
  scale_x_continuous(name="Expected effect size (in standard deviations)", breaks=c(-2, -1.5,-1,-0.5,0,0.5,1,1.5,2)) + 
  scale_y_continuous(name="Outcome", breaks=mean.expectations.1$Position, labels=mean.expectations.1$Hypothesis) + 
  theme_few()
ggsave(plot.expectations.1, file=here("Output", "For Publication", "Figures", "F_Expectations_1.png"), width=8, height=5)
